/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.level.entities.renderer.immortal;

import com.github.teamfusion.rottencreatures.client.level.entities.model.ImmortalModel;
import com.github.teamfusion.rottencreatures.client.level.entities.renderer.immortal.DashAttackLayer;
import com.github.teamfusion.rottencreatures.client.level.entities.renderer.immortal.ImmortalOverlayLayer;
import com.github.teamfusion.rottencreatures.client.level.entities.renderer.immortal.ImpaledLayer;
import com.github.teamfusion.rottencreatures.client.registries.RCModelLayers;
import com.github.teamfusion.rottencreatures.common.level.entities.immortal.Immortal;
import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;

public class ImmortalRenderer<T extends Immortal>
extends HumanoidMobRenderer<T, ImmortalModel<T>> {
    public ImmortalRenderer(EntityRendererProvider.Context context) {
        super(context, new ImmortalModel(context.bakeLayer(RCModelLayers.IMMORTAL)), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(RCModelLayers.IMMORTAL_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(RCModelLayers.IMMORTAL_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer(new ImpaledLayer(this, context.getModelSet()));
        this.addLayer(new DashAttackLayer(this, context.getModelSet()));
        this.addLayer(new ImmortalOverlayLayer(this, context.getModelSet()));
    }

    public ResourceLocation getTextureLocation(Immortal mob) {
        return RottenCreatures.resource("textures/entity/immortal/immortal.png");
    }

    protected void setupRotations(T immortal, PoseStack matrices, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations(immortal, matrices, bob, yBodyRot, partialTick, scale);
        if ((double)((Immortal)((Object)immortal)).walkAnimation.speed() >= 0.01) {
            float timestamp = ((Immortal)((Object)immortal)).walkAnimation.position(partialTick) + 6.0f;
            float degreeModifier = (Math.abs(timestamp % 13.0f - 6.5f) - 3.25f) / 3.25f;
            matrices.mulPose(Axis.ZP.rotationDegrees(6.5f * degreeModifier));
        }
    }
}

